<%@Page Explicit="True" Language="VB" Strict="True" Debug="True" %>
<%@Import Namespace="System.Data" %>
<%@Import namespace="System.Data.Oledb" %>
<html>
	<head>
	<title>chapt12-6.aspx Paging Database Results</title>
	</head>

	<script runat="server">

		Sub ButtonNClick (Sender As Object, E As EventArgs)
			If (carsTable.CurrentPageIndex < (carsTable.PageCount-1)) Then
				carsTable.CurrentPageIndex += 1
			End If
			Page.DataBind
		End Sub

		Sub ButtonPClick (Sender As Object, E As EventArgs)
			If (carsTable.CurrentPageIndex > 0) Then
				carsTable.CurrentPageIndex -= 1
			End If	
			Page.DataBind
		End Sub

		Sub Page_Load (Sender As Object, E As EventArgs)
			Dim myConnect As OleDbConnection = New OleDbConnection
			Dim myDbCommand As OleDbCommand = New OleDbCommand
			Dim myAdaptor As OleDbDataAdapter = New OleDbDataAdapter
			Dim CarsDataSet As DataSet = New DataSet
			
			myConnect.ConnectionString = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=c:\cars.mdb"

			myDbCommand.CommandText = "Select * From Cars"
			myDbCommand.Connection = myConnect

			myAdaptor.SelectCommand = myDbCommand
			myAdaptor.SelectCommand.Connection.Open
			myAdaptor.Fill(CarsDataSet, "Cars")

			carsTable.DataSource = CarsDataSet.Tables("Cars")
			carsTable.DataBind
		End Sub
	</script>

	<body>
	<h1>Cars Database</h1>
	<form runat="server">
	<asp:datagrid id="carsTable" runat="server" 
		AllowPaging="True" 
		PagerStyle-Visible="False"
		Pagesize="5"
		AutoGenerateColumns="False">

	<HeaderStyle BackColor="blue" ForeColor="yellow" Font-Size="8pt" />
	<ItemStyle BackColor="lightgreen" ForeColor="blue" Font-Size="8pt" />
	<AlternatingItemStyle BackColor="white" ForeColor="blue" Font-Size="8pt" />
	
	<Columns>
		<asp:BoundColumn DataField="CarId" Visible="False" />
		<asp:BoundColumn DataField="Make" HeaderText="Manufacturer" />
		<asp:BoundColumn DataField="Model" HeaderText="Model" />
		<asp:BoundColumn DataField="Colour" HeaderText="Colour" />	
 	</Columns>
	</asp:datagrid>
	<asp:linkbutton id="Prevbutton" Text="Prev" CommandArgument="Prev" runat="server"
	onclick="ButtonPClick"/>
	<asp:linkbutton id="Nextbutton" Text="Next" CommandArgument="Next" runat="server"
	onclick="ButtonNClick"/>
	</form>
	</body>
</html>

